/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Tty: ImageVector
    get() {
        if (_tty != null) {
            return _tty!!
        }
        _tty = materialIcon(name = "TwoTone.Tty") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.13f, 5.0f)
                curveTo(4.3f, 6.37f, 4.66f, 7.71f, 5.18f, 8.99f)
                lineToRelative(1.65f, -1.65f)
                lineTo(6.36f, 5.0f)
                horizontalLineTo(4.13f)
                close()
                moveTo(15.66f, 16.17f)
                lineToRelative(-1.65f, 1.65f)
                curveToRelative(1.28f, 0.52f, 2.63f, 0.87f, 3.99f, 1.05f)
                verticalLineToRelative(-2.23f)
                lineTo(15.66f, 16.17f)
                close()
            }
            materialPath {
                moveTo(19.2f, 14.84f)
                lineToRelative(-3.67f, -0.73f)
                curveToRelative(-0.33f, -0.07f, -0.67f, 0.04f, -0.9f, 0.27f)
                lineTo(12.1f, 16.9f)
                curveToRelative(-2.5f, -1.43f, -4.57f, -3.5f, -6.0f, -6.0f)
                lineToRelative(2.52f, -2.52f)
                curveTo(8.86f, 8.14f, 8.96f, 7.8f, 8.9f, 7.48f)
                lineTo(8.16f, 3.8f)
                curveTo(8.07f, 3.34f, 7.66f, 3.0f, 7.18f, 3.0f)
                horizontalLineTo(3.03f)
                curveTo(2.47f, 3.0f, 2.0f, 3.47f, 2.03f, 4.03f)
                curveTo(2.2f, 6.92f, 3.05f, 9.63f, 4.43f, 12.0f)
                curveToRelative(1.58f, 2.73f, 3.85f, 4.99f, 6.57f, 6.57f)
                curveToRelative(2.37f, 1.37f, 5.08f, 2.23f, 7.97f, 2.4f)
                curveToRelative(0.56f, 0.03f, 1.03f, -0.44f, 1.03f, -1.0f)
                verticalLineToRelative(-4.15f)
                curveTo(20.0f, 15.34f, 19.66f, 14.93f, 19.2f, 14.84f)
                close()
                moveTo(4.13f, 5.0f)
                horizontalLineToRelative(2.23f)
                lineToRelative(0.47f, 2.34f)
                lineTo(5.18f, 8.99f)
                curveTo(4.66f, 7.71f, 4.3f, 6.37f, 4.13f, 5.0f)
                close()
                moveTo(18.0f, 18.87f)
                curveToRelative(-1.37f, -0.17f, -2.71f, -0.53f, -3.99f, -1.05f)
                lineToRelative(1.65f, -1.65f)
                lineTo(18.0f, 16.64f)
                verticalLineTo(18.87f)
                close()
                moveTo(14.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(13.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(11.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                close()
                moveTo(18.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(19.0f, 6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(21.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(22.0f, 6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(14.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(11.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(19.0f, 12.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(22.0f, 12.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _tty!!
    }

private var _tty: ImageVector? = null
