/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.TransitEnterexit: ImageVector
    get() {
        if (_transitEnterexit != null) {
            return _transitEnterexit!!
        }
        _transitEnterexit = materialIcon(name = "TwoTone.TransitEnterexit") {
            materialPath {
                moveTo(15.98f, 6.0f)
                lineTo(9.0f, 12.77f)
                verticalLineTo(8.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-4.85f)
                lineTo(18.0f, 8.03f)
                close()
            }
        }
        return _transitEnterexit!!
    }

private var _transitEnterexit: ImageVector? = null
