/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Satellite: ImageVector
    get() {
        if (_satellite != null) {
            return _satellite!!
        }
        _satellite = materialIcon(name = "TwoTone.Satellite") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(14.0f)
                lineTo(19.0f, 5.0f)
                lineTo(5.0f, 5.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(6.0f, 6.0f)
                horizontalLineToRelative(2.57f)
                curveToRelative(0.0f, 1.42f, -1.15f, 2.58f, -2.57f, 2.58f)
                lineTo(6.0f, 6.0f)
                close()
                moveTo(6.0f, 10.29f)
                curveToRelative(2.37f, 0.0f, 4.28f, -1.93f, 4.28f, -4.29f)
                lineTo(12.0f, 6.0f)
                curveToRelative(0.0f, 3.31f, -2.68f, 6.0f, -6.0f, 6.0f)
                verticalLineToRelative(-1.71f)
                close()
                moveTo(9.0f, 13.15f)
                lineToRelative(2.14f, 2.58f)
                lineToRelative(3.0f, -3.86f)
                lineTo(18.0f, 17.0f)
                lineTo(6.0f, 17.0f)
                lineToRelative(3.0f, -3.85f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(19.0f, 19.0f)
                lineTo(5.0f, 19.0f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(8.57f, 6.0f)
                lineTo(6.0f, 6.0f)
                verticalLineToRelative(2.58f)
                curveToRelative(1.42f, 0.0f, 2.57f, -1.16f, 2.57f, -2.58f)
                close()
                moveTo(12.0f, 6.0f)
                horizontalLineToRelative(-1.72f)
                curveToRelative(0.0f, 2.36f, -1.91f, 4.29f, -4.28f, 4.29f)
                lineTo(6.0f, 12.0f)
                curveToRelative(3.32f, 0.0f, 6.0f, -2.69f, 6.0f, -6.0f)
                close()
                moveTo(14.14f, 11.86f)
                lineToRelative(-3.0f, 3.87f)
                lineTo(9.0f, 13.15f)
                lineTo(6.0f, 17.0f)
                horizontalLineToRelative(12.0f)
                close()
            }
        }
        return _satellite!!
    }

private var _satellite: ImageVector? = null
