/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MarkChatRead: ImageVector
    get() {
        if (_markChatRead != null) {
            return _markChatRead!!
        }
        _markChatRead = materialIcon(name = "TwoTone.MarkChatRead") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.0f, 10.0f)
                curveToRelative(0.34f, 0.0f, 0.67f, 0.03f, 1.0f, 0.08f)
                verticalLineTo(4.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(8.08f)
                curveTo(12.57f, 12.61f, 15.47f, 10.0f, 19.0f, 10.0f)
                close()
            }
            materialPath {
                moveTo(17.34f, 20.0f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(4.24f, -4.24f)
                lineTo(23.0f, 14.34f)
                lineTo(17.34f, 20.0f)
                close()
                moveTo(12.08f, 16.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(6.08f)
                curveToRelative(0.71f, 0.1f, 1.38f, 0.31f, 2.0f, 0.6f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(18.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.14f, 0.02f, -0.27f, 0.03f, -0.4f)
                curveTo(12.01f, 17.4f, 12.0f, 17.2f, 12.0f, 17.0f)
                curveTo(12.0f, 16.66f, 12.03f, 16.33f, 12.08f, 16.0f)
                close()
            }
        }
        return _markChatRead!!
    }

private var _markChatRead: ImageVector? = null
