/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FindReplace: ImageVector
    get() {
        if (_findReplace != null) {
            return _findReplace!!
        }
        _findReplace = materialIcon(name = "TwoTone.FindReplace") {
            materialPath {
                moveTo(11.0f, 6.0f)
                curveToRelative(1.38f, 0.0f, 2.63f, 0.56f, 3.54f, 1.46f)
                lineTo(12.0f, 10.0f)
                horizontalLineToRelative(6.0f)
                lineTo(18.0f, 4.0f)
                lineToRelative(-2.05f, 2.05f)
                curveTo(14.68f, 4.78f, 12.93f, 4.0f, 11.0f, 4.0f)
                curveToRelative(-3.53f, 0.0f, -6.43f, 2.61f, -6.92f, 6.0f)
                lineTo(6.1f, 10.0f)
                curveToRelative(0.46f, -2.28f, 2.48f, -4.0f, 4.9f, -4.0f)
                close()
                moveTo(16.64f, 15.14f)
                curveToRelative(0.66f, -0.9f, 1.12f, -1.97f, 1.28f, -3.14f)
                lineTo(15.9f, 12.0f)
                curveToRelative(-0.46f, 2.28f, -2.48f, 4.0f, -4.9f, 4.0f)
                curveToRelative(-1.38f, 0.0f, -2.63f, -0.56f, -3.54f, -1.46f)
                lineTo(10.0f, 12.0f)
                lineTo(4.0f, 12.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(2.05f, -2.05f)
                curveTo(7.32f, 17.22f, 9.07f, 18.0f, 11.0f, 18.0f)
                curveToRelative(1.55f, 0.0f, 2.98f, -0.51f, 4.14f, -1.36f)
                lineTo(20.0f, 21.49f)
                lineTo(21.49f, 20.0f)
                lineToRelative(-4.85f, -4.86f)
                close()
            }
        }
        return _findReplace!!
    }

private var _findReplace: ImageVector? = null
