/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FiberDvr: ImageVector
    get() {
        if (_fiberDvr != null) {
            return _fiberDvr!!
        }
        _fiberDvr = materialIcon(name = "TwoTone.FiberDvr") {
            materialPath {
                moveTo(20.0f, 11.56f)
                verticalLineToRelative(-0.89f)
                curveToRelative(0.0f, -0.76f, -0.58f, -1.33f, -1.33f, -1.33f)
                horizontalLineToRelative(-3.11f)
                verticalLineToRelative(5.33f)
                horizontalLineToRelative(1.33f)
                verticalLineToRelative(-1.78f)
                horizontalLineToRelative(1.02f)
                lineToRelative(0.76f, 1.78f)
                lineTo(20.0f, 14.67f)
                lineToRelative(-0.8f, -1.87f)
                curveToRelative(0.44f, -0.22f, 0.8f, -0.71f, 0.8f, -1.24f)
                close()
                moveTo(18.67f, 11.56f)
                horizontalLineToRelative(-1.78f)
                verticalLineToRelative(-0.89f)
                horizontalLineToRelative(1.78f)
                verticalLineToRelative(0.89f)
                close()
                moveTo(7.11f, 9.33f)
                lineTo(4.0f, 9.33f)
                verticalLineToRelative(5.33f)
                horizontalLineToRelative(3.11f)
                curveToRelative(0.76f, 0.0f, 1.33f, -0.58f, 1.33f, -1.33f)
                verticalLineToRelative(-2.67f)
                curveToRelative(0.0f, -0.75f, -0.57f, -1.33f, -1.33f, -1.33f)
                close()
                moveTo(7.11f, 13.33f)
                lineTo(5.33f, 13.33f)
                verticalLineToRelative(-2.67f)
                horizontalLineToRelative(1.78f)
                verticalLineToRelative(2.67f)
                close()
                moveTo(14.11f, 9.33f)
                horizontalLineToRelative(-1.34f)
                lineToRelative(-0.89f, 3.05f)
                lineTo(11.0f, 9.33f)
                lineTo(9.66f, 9.33f)
                lineToRelative(1.56f, 5.34f)
                horizontalLineToRelative(1.33f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 5.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(3.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                curveToRelative(-1.11f, 0.0f, -2.0f, 0.89f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 5.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(21.0f, 19.0f)
                lineTo(3.0f, 19.0f)
                lineTo(3.0f, 5.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(14.0f)
                close()
            }
        }
        return _fiberDvr!!
    }

private var _fiberDvr: ImageVector? = null
