/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DomainDisabled: ImageVector
    get() {
        if (_domainDisabled != null) {
            return _domainDisabled!!
        }
        _domainDisabled = materialIcon(name = "TwoTone.DomainDisabled") {
            materialPath {
                moveTo(1.41f, 1.69f)
                lineTo(0.0f, 3.1f)
                lineToRelative(2.0f, 2.0f)
                lineTo(2.0f, 21.0f)
                horizontalLineToRelative(15.9f)
                lineToRelative(3.0f, 3.0f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-20.9f, -20.9f)
                close()
                moveTo(6.0f, 19.0f)
                lineTo(4.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(6.0f, 15.0f)
                lineTo(4.0f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(4.0f, 11.0f)
                lineTo(4.0f, 9.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                lineTo(4.0f, 11.0f)
                close()
                moveTo(10.0f, 19.0f)
                lineTo(8.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(8.0f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                lineTo(8.0f, 15.0f)
                close()
                moveTo(12.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.9f)
                lineToRelative(2.0f, 2.0f)
                lineTo(12.0f, 19.0f)
                close()
                moveTo(8.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-0.45f)
                lineTo(12.0f, 9.45f)
                lineTo(12.0f, 9.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(8.45f)
                lineToRelative(2.0f, 2.0f)
                lineTo(22.0f, 7.0f)
                lineTo(12.0f, 7.0f)
                lineTo(12.0f, 3.0f)
                lineTo(5.55f, 3.0f)
                lineTo(8.0f, 5.45f)
                close()
                moveTo(16.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 9.0f)
                verticalLineToRelative(0.45f)
                lineToRelative(8.0f, 8.0f)
                lineTo(20.0f, 9.0f)
                horizontalLineToRelative(-8.0f)
                close()
                moveTo(18.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
            }
        }
        return _domainDisabled!!
    }

private var _domainDisabled: ImageVector? = null
