/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CompassCalibration: ImageVector
    get() {
        if (_compassCalibration != null) {
            return _compassCalibration!!
        }
        _compassCalibration = materialIcon(name = "TwoTone.CompassCalibration") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.94f, 7.26f)
                lineToRelative(2.21f, 2.21f)
                curveToRelative(1.44f, -0.91f, 3.11f, -1.4f, 4.85f, -1.4f)
                curveToRelative(1.74f, 0.0f, 3.41f, 0.49f, 4.84f, 1.4f)
                lineToRelative(2.21f, -2.21f)
                curveTo(17.0f, 5.79f, 14.56f, 5.0f, 12.0f, 5.0f)
                curveToRelative(-2.56f, 0.0f, -5.01f, 0.79f, -7.06f, 2.26f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 17.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
            materialPath {
                moveTo(17.0f, 17.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                reflectiveCurveToRelative(-5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                close()
                moveTo(9.0f, 17.0f)
                curveToRelative(0.0f, -1.65f, 1.35f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveToRelative(-1.35f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.35f, -3.0f, -3.0f)
                close()
                moveTo(2.0f, 7.15f)
                lineToRelative(5.0f, 5.0f)
                curveToRelative(1.28f, -1.28f, 3.05f, -2.08f, 5.0f, -2.08f)
                reflectiveCurveToRelative(3.72f, 0.79f, 5.0f, 2.07f)
                lineToRelative(5.0f, -5.0f)
                curveTo(19.44f, 4.59f, 15.9f, 3.0f, 12.0f, 3.0f)
                curveTo(8.1f, 3.0f, 4.56f, 4.59f, 2.0f, 7.15f)
                close()
                moveTo(16.84f, 9.47f)
                curveToRelative(-1.44f, -0.91f, -3.1f, -1.4f, -4.84f, -1.4f)
                curveToRelative(-1.74f, 0.0f, -3.41f, 0.49f, -4.85f, 1.41f)
                lineTo(4.94f, 7.26f)
                curveTo(6.99f, 5.79f, 9.44f, 5.0f, 12.0f, 5.0f)
                curveToRelative(2.56f, 0.0f, 5.0f, 0.79f, 7.05f, 2.26f)
                lineToRelative(-2.21f, 2.21f)
                close()
            }
        }
        return _compassCalibration!!
    }

private var _compassCalibration: ImageVector? = null
