/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CircleNotifications: ImageVector
    get() {
        if (_circleNotifications != null) {
            return _circleNotifications!!
        }
        _circleNotifications = materialIcon(name = "TwoTone.CircleNotifications") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, 3.59f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.59f, 8.0f, 8.0f, 8.0f)
                curveToRelative(4.41f, 0.0f, 8.0f, -3.59f, 8.0f, -8.0f)
                reflectiveCurveTo(16.41f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(12.0f, 18.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                horizontalLineToRelative(3.0f)
                curveTo(13.5f, 17.83f, 12.83f, 18.5f, 12.0f, 18.5f)
                close()
                moveTo(17.0f, 16.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-2.61f)
                curveTo(8.0f, 9.27f, 9.03f, 7.47f, 11.0f, 7.0f)
                verticalLineTo(6.5f)
                curveToRelative(0.0f, -0.57f, 0.43f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.43f, 1.0f, 1.0f)
                verticalLineTo(7.0f)
                curveToRelative(1.97f, 0.47f, 3.0f, 2.28f, 3.0f, 4.39f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 18.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                horizontalLineToRelative(-3.0f)
                curveTo(10.5f, 17.83f, 11.17f, 18.5f, 12.0f, 18.5f)
                close()
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(5.52f, 0.0f, 10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.59f, -8.0f, 8.0f, -8.0f)
                curveToRelative(4.41f, 0.0f, 8.0f, 3.59f, 8.0f, 8.0f)
                reflectiveCurveTo(16.41f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(16.0f, 11.39f)
                curveToRelative(0.0f, -2.11f, -1.03f, -3.92f, -3.0f, -4.39f)
                verticalLineTo(6.5f)
                curveToRelative(0.0f, -0.57f, -0.43f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.43f, -1.0f, 1.0f)
                verticalLineTo(7.0f)
                curveToRelative(-1.97f, 0.47f, -3.0f, 2.27f, -3.0f, 4.39f)
                verticalLineTo(14.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(11.39f)
                close()
                moveTo(14.0f, 14.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineTo(14.0f)
                close()
            }
        }
        return _circleNotifications!!
    }

private var _circleNotifications: ImageVector? = null
