/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp._360: ImageVector
    get() {
        if (__360 != null) {
            return __360!!
        }
        __360 = materialIcon(name = "Sharp._360") {
            materialPath {
                moveTo(12.0f, 7.0f)
                curveTo(6.48f, 7.0f, 2.0f, 9.24f, 2.0f, 12.0f)
                curveToRelative(0.0f, 2.24f, 2.94f, 4.13f, 7.0f, 4.77f)
                verticalLineTo(20.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-4.0f, -4.0f)
                verticalLineToRelative(2.73f)
                curveToRelative(-3.15f, -0.56f, -5.0f, -1.9f, -5.0f, -2.73f)
                curveToRelative(0.0f, -1.06f, 3.04f, -3.0f, 8.0f, -3.0f)
                reflectiveCurveToRelative(8.0f, 1.94f, 8.0f, 3.0f)
                curveToRelative(0.0f, 0.73f, -1.46f, 1.89f, -4.0f, 2.53f)
                verticalLineToRelative(2.05f)
                curveToRelative(3.53f, -0.77f, 6.0f, -2.53f, 6.0f, -4.58f)
                curveToRelative(0.0f, -2.76f, -4.48f, -5.0f, -10.0f, -5.0f)
                close()
            }
        }
        return __360!!
    }

private var __360: ImageVector? = null
