/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.WorkOff: ImageVector
    get() {
        if (_workOff != null) {
            return _workOff!!
        }
        _workOff = materialIcon(name = "Sharp.WorkOff") {
            materialPath {
                moveTo(10.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.6f)
                lineTo(22.0f, 17.6f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.98f, 0.0f, -1.79f, 0.71f, -1.96f, 1.64f)
                lineTo(10.0f, 5.6f)
                verticalLineTo(4.0f)
                close()
                moveTo(3.4f, 1.84f)
                lineTo(1.99f, 3.25f)
                lineTo(4.74f, 6.0f)
                horizontalLineTo(2.01f)
                lineTo(2.0f, 21.0f)
                horizontalLineToRelative(17.74f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _workOff!!
    }

private var _workOff: ImageVector? = null
