/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VapeFree: ImageVector
    get() {
        if (_vapeFree != null) {
            return _vapeFree!!
        }
        _vapeFree = materialIcon(name = "Sharp.VapeFree") {
            materialPath {
                moveTo(2.0f, 16.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.33f, 0.0f, 2.71f, -0.18f, 4.0f, -0.5f)
                verticalLineToRelative(3.0f)
                curveToRelative(-1.29f, -0.32f, -2.67f, -0.5f, -4.0f, -0.5f)
                horizontalLineTo(2.0f)
                verticalLineTo(16.5f)
                close()
                moveTo(16.17f, 19.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(5.17f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(16.17f, 19.0f)
                close()
                moveTo(18.83f, 16.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-0.17f)
                lineTo(18.83f, 16.0f)
                close()
                moveTo(11.0f, 17.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                reflectiveCurveTo(10.0f, 17.22f, 10.0f, 17.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                reflectiveCurveTo(11.0f, 17.78f, 11.0f, 17.5f)
                close()
                moveTo(22.0f, 12.76f)
                verticalLineTo(15.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-2.23f)
                curveToRelative(0.0f, -2.24f, -1.76f, -4.07f, -4.0f, -4.07f)
                verticalLineTo(7.2f)
                curveToRelative(1.02f, 0.0f, 1.85f, -0.83f, 1.85f, -1.85f)
                reflectiveCurveTo(17.52f, 3.5f, 16.5f, 3.5f)
                verticalLineTo(2.0f)
                curveToRelative(1.85f, 0.0f, 3.35f, 1.5f, 3.35f, 3.35f)
                curveToRelative(0.0f, 0.93f, -0.38f, 1.77f, -1.0f, 2.38f)
                curveTo(20.72f, 8.62f, 22.0f, 10.54f, 22.0f, 12.76f)
                close()
                moveTo(11.15f, 8.32f)
                curveToRelative(0.0f, -0.01f, 0.0f, -0.01f, 0.0f, -0.02f)
                curveToRelative(0.0f, -1.85f, 1.5f, -3.35f, 3.35f, -3.35f)
                verticalLineToRelative(1.5f)
                curveToRelative(-1.02f, 0.0f, -1.85f, 0.73f, -1.85f, 1.75f)
                reflectiveCurveToRelative(0.83f, 2.0f, 1.85f, 2.0f)
                horizontalLineToRelative(1.53f)
                curveToRelative(1.87f, 0.0f, 3.47f, 1.35f, 3.47f, 3.16f)
                verticalLineTo(15.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-1.3f)
                curveToRelative(0.0f, -1.31f, -0.92f, -2.05f, -1.97f, -2.05f)
                horizontalLineTo(14.5f)
                curveToRelative(-0.01f, 0.0f, -0.01f, 0.0f, -0.02f, 0.0f)
                lineTo(11.15f, 8.32f)
                close()
            }
        }
        return _vapeFree!!
    }

private var _vapeFree: ImageVector? = null
