/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwipeDown: ImageVector
    get() {
        if (_swipeDown != null) {
            return _swipeDown!!
        }
        _swipeDown = materialIcon(name = "Sharp.SwipeDown") {
            materialPath {
                moveTo(3.8f, 12.18f)
                curveToRelative(-0.2f, -0.86f, -0.3f, -1.76f, -0.3f, -2.68f)
                curveToRelative(0.0f, -2.84f, 0.99f, -5.45f, 2.63f, -7.5f)
                lineTo(7.2f, 3.07f)
                curveTo(5.82f, 4.85f, 5.0f, 7.08f, 5.0f, 9.5f)
                curveToRelative(0.0f, 0.88f, 0.11f, 1.74f, 0.32f, 2.56f)
                lineToRelative(1.62f, -1.62f)
                lineTo(8.0f, 11.5f)
                lineTo(4.5f, 15.0f)
                lineTo(1.0f, 11.5f)
                lineToRelative(1.06f, -1.06f)
                lineTo(3.8f, 12.18f)
                close()
            }
            materialPath {
                moveTo(21.71f, 11.18f)
                lineToRelative(2.09f, 7.39f)
                lineToRelative(-8.23f, 3.65f)
                lineToRelative(-6.84f, -2.85f)
                lineToRelative(0.61f, -1.62f)
                lineToRelative(3.8f, -0.75f)
                lineTo(8.79f, 7.17f)
                curveToRelative(-0.34f, -0.76f, 0.0f, -1.64f, 0.76f, -1.98f)
                curveToRelative(0.76f, -0.34f, 1.64f, 0.0f, 1.98f, 0.76f)
                lineToRelative(2.43f, 5.49f)
                lineToRelative(1.26f, -0.56f)
                lineTo(21.71f, 11.18f)
                close()
            }
        }
        return _swipeDown!!
    }

private var _swipeDown: ImageVector? = null
