/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SsidChart: ImageVector
    get() {
        if (_ssidChart != null) {
            return _ssidChart!!
        }
        _ssidChart = materialIcon(name = "Sharp.SsidChart") {
            materialPath {
                moveTo(21.0f, 5.47f)
                lineTo(12.0f, 12.0f)
                lineTo(7.62f, 7.62f)
                lineTo(3.0f, 11.0f)
                verticalLineTo(8.52f)
                lineTo(7.83f, 5.0f)
                lineToRelative(4.38f, 4.38f)
                lineTo(21.0f, 3.0f)
                lineTo(21.0f, 5.47f)
                close()
                moveTo(21.0f, 15.0f)
                horizontalLineToRelative(-4.7f)
                lineToRelative(-4.17f, 3.34f)
                lineTo(6.0f, 12.41f)
                lineToRelative(-3.0f, 2.13f)
                lineTo(3.0f, 17.0f)
                lineToRelative(2.8f, -2.0f)
                lineToRelative(6.2f, 6.0f)
                lineToRelative(5.0f, -4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _ssidChart!!
    }

private var _ssidChart: ImageVector? = null
