/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SportsFootball: ImageVector
    get() {
        if (_sportsFootball != null) {
            return _sportsFootball!!
        }
        _sportsFootball = materialIcon(name = "Sharp.SportsFootball") {
            materialPath {
                moveTo(3.02f, 15.62f)
                curveToRelative(-0.08f, 2.42f, 0.32f, 4.34f, 0.67f, 4.69f)
                reflectiveCurveToRelative(2.28f, 0.76f, 4.69f, 0.67f)
                lineTo(3.02f, 15.62f)
                close()
            }
            materialPath {
                moveTo(13.08f, 3.28f)
                curveTo(10.75f, 3.7f, 8.29f, 4.62f, 6.46f, 6.46f)
                reflectiveCurveToRelative(-2.76f, 4.29f, -3.18f, 6.62f)
                lineToRelative(7.63f, 7.63f)
                curveToRelative(2.34f, -0.41f, 4.79f, -1.34f, 6.62f, -3.18f)
                reflectiveCurveToRelative(2.76f, -4.29f, 3.18f, -6.62f)
                lineTo(13.08f, 3.28f)
                close()
                moveTo(9.9f, 15.5f)
                lineToRelative(-1.4f, -1.4f)
                lineToRelative(5.6f, -5.6f)
                lineToRelative(1.4f, 1.4f)
                lineTo(9.9f, 15.5f)
                close()
            }
            materialPath {
                moveTo(20.98f, 8.38f)
                curveToRelative(0.08f, -2.42f, -0.32f, -4.34f, -0.67f, -4.69f)
                reflectiveCurveToRelative(-2.28f, -0.76f, -4.69f, -0.67f)
                lineTo(20.98f, 8.38f)
                close()
            }
        }
        return _sportsFootball!!
    }

private var _sportsFootball: ImageVector? = null
