/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RoundaboutLeft: ImageVector
    get() {
        if (_roundaboutLeft != null) {
            return _roundaboutLeft!!
        }
        _roundaboutLeft = materialIcon(name = "Sharp.RoundaboutLeft") {
            materialPath {
                moveTo(16.0f, 13.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(-6.17f, 0.0f)
                lineToRelative(1.59f, 1.59f)
                lineTo(6.0f, 13.0f)
                lineTo(2.0f, 9.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(5.83f, 8.0f)
                lineToRelative(4.25f, 0.0f)
                curveToRelative(0.48f, -2.84f, 2.94f, -5.0f, 5.92f, -5.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, 2.69f, 6.0f, 6.0f)
                curveToRelative(0.0f, 2.97f, -2.16f, 5.44f, -5.0f, 5.92f)
                lineTo(17.0f, 21.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(0.0f, -8.0f)
                lineTo(16.0f, 13.0f)
                close()
            }
        }
        return _roundaboutLeft!!
    }

private var _roundaboutLeft: ImageVector? = null
