/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PanoramaPhotosphereSelect: ImageVector
    get() {
        if (_panoramaPhotosphereSelect != null) {
            return _panoramaPhotosphereSelect!!
        }
        _panoramaPhotosphereSelect = materialIcon(name = "Sharp.PanoramaPhotosphereSelect") {
            materialPath {
                moveTo(23.0f, 8.84f)
                curveToRelative(-0.54f, -0.43f, -1.23f, -0.81f, -1.99f, -1.15f)
                curveTo(19.4f, 4.33f, 15.98f, 2.0f, 12.0f, 2.0f)
                curveTo(8.02f, 2.0f, 4.6f, 4.33f, 2.99f, 7.68f)
                curveTo(2.23f, 8.03f, 1.54f, 8.4f, 1.0f, 8.84f)
                verticalLineToRelative(6.33f)
                curveToRelative(0.54f, 0.43f, 1.23f, 0.81f, 1.99f, 1.15f)
                curveTo(4.6f, 19.67f, 8.02f, 22.0f, 12.0f, 22.0f)
                curveToRelative(3.98f, 0.0f, 7.4f, -2.33f, 9.01f, -5.68f)
                curveToRelative(0.76f, -0.34f, 1.45f, -0.72f, 1.99f, -1.15f)
                verticalLineTo(8.84f)
                close()
                moveTo(12.0f, 4.0f)
                curveToRelative(2.37f, 0.0f, 4.49f, 1.04f, 5.95f, 2.68f)
                curveTo(16.17f, 6.25f, 14.15f, 6.0f, 12.0f, 6.0f)
                curveTo(9.85f, 6.0f, 7.83f, 6.25f, 6.05f, 6.68f)
                curveTo(7.51f, 5.04f, 9.63f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-2.37f, 0.0f, -4.49f, -1.04f, -5.95f, -2.68f)
                curveTo(7.83f, 17.75f, 9.85f, 18.0f, 12.0f, 18.0f)
                reflectiveCurveToRelative(4.17f, -0.25f, 5.95f, -0.68f)
                curveTo(16.49f, 18.96f, 14.37f, 20.0f, 12.0f, 20.0f)
                close()
            }
        }
        return _panoramaPhotosphereSelect!!
    }

private var _panoramaPhotosphereSelect: ImageVector? = null
