/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoBackpack: ImageVector
    get() {
        if (_noBackpack != null) {
            return _noBackpack!!
        }
        _noBackpack = materialIcon(name = "Sharp.NoBackpack") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(2.76f, 2.76f)
                curveTo(4.06f, 7.31f, 4.0f, 7.64f, 4.0f, 8.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(15.17f)
                lineToRelative(0.61f, 0.61f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(6.0f, 14.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(6.0f)
                close()
                moveTo(6.98f, 4.15f)
                curveToRelative(0.01f, 0.0f, 0.01f, -0.01f, 0.02f, -0.01f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.14f)
                curveToRelative(1.72f, 0.45f, 3.0f, 2.0f, 3.0f, 3.86f)
                verticalLineToRelative(9.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-3.17f)
                lineTo(6.98f, 4.15f)
                close()
            }
        }
        return _noBackpack!!
    }

private var _noBackpack: ImageVector? = null
