/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NearMeDisabled: ImageVector
    get() {
        if (_nearMeDisabled != null) {
            return _nearMeDisabled!!
        }
        _nearMeDisabled = materialIcon(name = "Sharp.NearMeDisabled") {
            materialPath {
                moveTo(12.0f, 6.34f)
                lineTo(21.0f, 3.0f)
                lineToRelative(-3.34f, 9.0f)
                lineTo(12.0f, 6.34f)
                close()
                moveTo(22.61f, 19.78f)
                lineTo(4.22f, 1.39f)
                lineTo(2.81f, 2.81f)
                lineToRelative(5.07f, 5.07f)
                lineTo(3.0f, 9.69f)
                verticalLineToRelative(1.41f)
                lineToRelative(7.07f, 2.83f)
                lineTo(12.9f, 21.0f)
                horizontalLineToRelative(1.41f)
                lineToRelative(1.81f, -4.88f)
                lineToRelative(5.07f, 5.07f)
                lineTo(22.61f, 19.78f)
                close()
            }
        }
        return _nearMeDisabled!!
    }

private var _nearMeDisabled: ImageVector? = null
