/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Lan: ImageVector
    get() {
        if (_lan != null) {
            return _lan!!
        }
        _lan = materialIcon(name = "Sharp.Lan") {
            materialPath {
                moveTo(13.0f, 22.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, -4.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-8.0f, 0.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-3.0f, 0.0f)
                close()
            }
        }
        return _lan!!
    }

private var _lan: ImageVector? = null
