/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.KebabDining: ImageVector
    get() {
        if (_kebabDining != null) {
            return _kebabDining!!
        }
        _kebabDining = materialIcon(name = "Sharp.KebabDining") {
            materialPath {
                moveTo(7.75f, 8.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(7.75f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(8.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.12f, 2.5f, 2.5f)
                reflectiveCurveTo(9.88f, 19.0f, 8.5f, 19.0f)
                horizontalLineTo(7.75f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(5.5f)
                curveTo(4.12f, 19.0f, 3.0f, 17.88f, 3.0f, 16.5f)
                reflectiveCurveTo(4.12f, 14.0f, 5.5f, 14.0f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(3.25f)
                verticalLineTo(7.0f)
                horizontalLineTo(5.5f)
                curveTo(4.12f, 7.0f, 3.0f, 5.88f, 3.0f, 4.5f)
                reflectiveCurveTo(4.12f, 2.0f, 5.5f, 2.0f)
                horizontalLineToRelative(0.75f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(8.5f)
                curveTo(9.88f, 2.0f, 11.0f, 3.12f, 11.0f, 4.5f)
                reflectiveCurveTo(9.88f, 7.0f, 8.5f, 7.0f)
                horizontalLineTo(7.75f)
                verticalLineTo(8.0f)
                close()
                moveTo(17.75f, 7.0f)
                horizontalLineToRelative(0.75f)
                curveTo(19.88f, 7.0f, 21.0f, 5.88f, 21.0f, 4.5f)
                reflectiveCurveTo(19.88f, 2.0f, 18.5f, 2.0f)
                horizontalLineToRelative(-0.75f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(15.5f)
                curveTo(14.12f, 2.0f, 13.0f, 3.12f, 13.0f, 4.5f)
                reflectiveCurveTo(14.12f, 7.0f, 15.5f, 7.0f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(3.25f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(15.5f)
                curveToRelative(-1.38f, 0.0f, -2.5f, 1.12f, -2.5f, 2.5f)
                reflectiveCurveToRelative(1.12f, 2.5f, 2.5f, 2.5f)
                horizontalLineToRelative(0.75f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(0.75f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                reflectiveCurveTo(19.88f, 14.0f, 18.5f, 14.0f)
                horizontalLineToRelative(-0.75f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(21.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-3.25f)
                verticalLineTo(7.0f)
                close()
            }
        }
        return _kebabDining!!
    }

private var _kebabDining: ImageVector? = null
