/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HouseSiding: ImageVector
    get() {
        if (_houseSiding != null) {
            return _houseSiding!!
        }
        _houseSiding = materialIcon(name = "Sharp.HouseSiding") {
            materialPath {
                moveTo(19.0f, 12.0f)
                horizontalLineToRelative(3.0f)
                lineTo(12.0f, 3.0f)
                lineTo(2.0f, 12.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(7.21f, 10.0f)
                horizontalLineToRelative(9.58f)
                lineTo(17.0f, 10.19f)
                verticalLineTo(12.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-1.81f)
                lineTo(7.21f, 10.0f)
                close()
                moveTo(14.57f, 8.0f)
                horizontalLineTo(9.43f)
                lineTo(12.0f, 5.69f)
                lineTo(14.57f, 8.0f)
                close()
                moveTo(7.0f, 16.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _houseSiding!!
    }

private var _houseSiding: ImageVector? = null
