/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "Sharp.HomeWork") {
            materialPath {
                moveTo(8.17f, 5.7f)
                lineTo(1.0f, 10.48f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(10.25f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                verticalLineToRelative(1.51f)
                lineToRelative(2.0f, 1.33f)
                lineTo(13.73f, 7.0f)
                lineTo(15.0f, 7.0f)
                verticalLineToRelative(0.85f)
                lineToRelative(2.0f, 1.34f)
                lineTo(17.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(6.0f)
                lineTo(23.0f, 3.0f)
                lineTo(10.0f, 3.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(17.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
