/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Forward10: ImageVector
    get() {
        if (_forward10 != null) {
            return _forward10!!
        }
        _forward10 = materialIcon(name = "Sharp.Forward10") {
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(0.0f, 3.31f, -2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                reflectiveCurveToRelative(2.69f, -6.0f, 6.0f, -6.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(5.0f, -5.0f)
                lineToRelative(-5.0f, -5.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, 3.58f, -8.0f, 8.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                horizontalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(10.9f, 16.0f)
                lineToRelative(0.0f, -4.27f)
                lineToRelative(-0.09f, 0.0f)
                lineToRelative(-1.77f, 0.63f)
                lineToRelative(0.0f, 0.69f)
                lineToRelative(1.01f, -0.31f)
                lineToRelative(0.0f, 3.26f)
                close()
            }
            materialPath {
                moveTo(14.32f, 11.78f)
                curveToRelative(-0.18f, -0.07f, -0.37f, -0.1f, -0.59f, -0.1f)
                reflectiveCurveToRelative(-0.41f, 0.03f, -0.59f, 0.1f)
                reflectiveCurveToRelative(-0.33f, 0.18f, -0.45f, 0.33f)
                reflectiveCurveToRelative(-0.23f, 0.34f, -0.29f, 0.57f)
                reflectiveCurveToRelative(-0.1f, 0.5f, -0.1f, 0.82f)
                verticalLineToRelative(0.74f)
                curveToRelative(0.0f, 0.32f, 0.04f, 0.6f, 0.11f, 0.82f)
                reflectiveCurveToRelative(0.17f, 0.42f, 0.3f, 0.57f)
                reflectiveCurveToRelative(0.28f, 0.26f, 0.46f, 0.33f)
                reflectiveCurveToRelative(0.37f, 0.1f, 0.59f, 0.1f)
                reflectiveCurveToRelative(0.41f, -0.03f, 0.59f, -0.1f)
                reflectiveCurveToRelative(0.33f, -0.18f, 0.45f, -0.33f)
                reflectiveCurveToRelative(0.22f, -0.34f, 0.29f, -0.57f)
                reflectiveCurveToRelative(0.1f, -0.5f, 0.1f, -0.82f)
                verticalLineTo(13.5f)
                curveToRelative(0.0f, -0.32f, -0.04f, -0.6f, -0.11f, -0.82f)
                reflectiveCurveToRelative(-0.17f, -0.42f, -0.3f, -0.57f)
                reflectiveCurveTo(14.49f, 11.85f, 14.32f, 11.78f)
                close()
                moveTo(14.33f, 14.35f)
                curveToRelative(0.0f, 0.19f, -0.01f, 0.35f, -0.04f, 0.48f)
                reflectiveCurveToRelative(-0.06f, 0.24f, -0.11f, 0.32f)
                reflectiveCurveToRelative(-0.11f, 0.14f, -0.19f, 0.17f)
                reflectiveCurveToRelative(-0.16f, 0.05f, -0.25f, 0.05f)
                reflectiveCurveToRelative(-0.18f, -0.02f, -0.25f, -0.05f)
                reflectiveCurveToRelative(-0.14f, -0.09f, -0.19f, -0.17f)
                reflectiveCurveToRelative(-0.09f, -0.19f, -0.12f, -0.32f)
                reflectiveCurveToRelative(-0.04f, -0.29f, -0.04f, -0.48f)
                verticalLineToRelative(-0.97f)
                curveToRelative(0.0f, -0.19f, 0.01f, -0.35f, 0.04f, -0.48f)
                reflectiveCurveToRelative(0.06f, -0.23f, 0.12f, -0.31f)
                reflectiveCurveToRelative(0.11f, -0.14f, 0.19f, -0.17f)
                reflectiveCurveToRelative(0.16f, -0.05f, 0.25f, -0.05f)
                reflectiveCurveToRelative(0.18f, 0.02f, 0.25f, 0.05f)
                reflectiveCurveToRelative(0.14f, 0.09f, 0.19f, 0.17f)
                reflectiveCurveToRelative(0.09f, 0.18f, 0.12f, 0.31f)
                reflectiveCurveToRelative(0.04f, 0.29f, 0.04f, 0.48f)
                verticalLineTo(14.35f)
                close()
            }
        }
        return _forward10!!
    }

private var _forward10: ImageVector? = null
