/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EnergySavingsLeaf: ImageVector
    get() {
        if (_energySavingsLeaf != null) {
            return _energySavingsLeaf!!
        }
        _energySavingsLeaf = materialIcon(name = "Sharp.EnergySavingsLeaf") {
            materialPath {
                moveTo(12.0f, 3.0f)
                curveToRelative(-4.8f, 0.0f, -9.0f, 3.86f, -9.0f, 9.0f)
                curveToRelative(0.0f, 2.12f, 0.74f, 4.07f, 1.97f, 5.61f)
                lineTo(3.0f, 19.59f)
                lineTo(4.41f, 21.0f)
                lineToRelative(1.97f, -1.97f)
                curveTo(7.93f, 20.26f, 9.88f, 21.0f, 12.0f, 21.0f)
                curveToRelative(2.3f, 0.0f, 4.61f, -0.88f, 6.36f, -2.64f)
                curveTo(20.12f, 16.61f, 21.0f, 14.3f, 21.0f, 12.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(12.0f)
                close()
                moveTo(10.5f, 17.0f)
                lineTo(10.0f, 16.5f)
                lineToRelative(2.5f, -3.5f)
                lineToRelative(-5.0f, -0.5f)
                lineToRelative(6.0f, -5.5f)
                lineTo(14.0f, 7.5f)
                lineTo(11.5f, 11.0f)
                lineToRelative(5.0f, 0.5f)
                lineTo(10.5f, 17.0f)
                close()
            }
        }
        return _energySavingsLeaf!!
    }

private var _energySavingsLeaf: ImageVector? = null
