/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DriveFileRenameOutline: ImageVector
    get() {
        if (_driveFileRenameOutline != null) {
            return _driveFileRenameOutline!!
        }
        _driveFileRenameOutline = materialIcon(name = "Sharp.DriveFileRenameOutline") {
            materialPath {
                moveTo(15.0f, 16.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(10.0f, 0.0f)
                lineToRelative(0.0f, -4.0f)
                close()
            }
            materialPath {
                moveTo(12.06f, 7.19f)
                lineToRelative(-9.06f, 9.06f)
                lineToRelative(0.0f, 3.75f)
                lineToRelative(3.75f, 0.0f)
                lineToRelative(9.06f, -9.06f)
                close()
            }
            materialPath {
                moveTo(13.132f, 6.1227f)
                lineToRelative(2.5385f, -2.5385f)
                lineToRelative(3.7476f, 3.7476f)
                lineToRelative(-2.5385f, 2.5385f)
                close()
            }
        }
        return _driveFileRenameOutline!!
    }

private var _driveFileRenameOutline: ImageVector? = null
