/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DoNotStep: ImageVector
    get() {
        if (_doNotStep != null) {
            return _doNotStep!!
        }
        _doNotStep = materialIcon(name = "Sharp.DoNotStep") {
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(8.24f, 8.24f)
                lineToRelative(-0.69f, 0.72f)
                lineTo(6.87f, 11.1f)
                curveToRelative(-0.11f, 0.4f, -0.26f, 0.78f, -0.45f, 1.12f)
                lineToRelative(1.75f, 1.75f)
                lineToRelative(-0.69f, 0.72f)
                lineToRelative(-1.63f, -1.63f)
                curveToRelative(-0.24f, 0.29f, -0.5f, 0.56f, -0.77f, 0.8f)
                lineToRelative(1.63f, 1.63f)
                lineToRelative(-0.7f, 0.72f)
                lineToRelative(-1.74f, -1.74f)
                curveTo(2.83f, 15.43f, 1.34f, 15.82f, 1.0f, 15.92f)
                lineTo(1.0f, 20.0f)
                horizontalLineToRelative(9.5f)
                lineToRelative(3.33f, -3.33f)
                lineToRelative(5.94f, 5.94f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(18.51f, 15.68f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(4.48f, -4.48f)
                lineTo(23.0f, 11.2f)
                lineTo(18.51f, 15.68f)
                close()
                moveTo(20.88f, 9.08f)
                lineToRelative(-4.48f, 4.48f)
                lineTo(9.3f, 6.47f)
                lineTo(13.8f, 2.0f)
                lineTo(20.88f, 9.08f)
                close()
            }
        }
        return _doNotStep!!
    }

private var _doNotStep: ImageVector? = null
