/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ChargingStation: ImageVector
    get() {
        if (_chargingStation != null) {
            return _chargingStation!!
        }
        _chargingStation = materialIcon(name = "Sharp.ChargingStation") {
            materialPath {
                moveTo(14.5f, 11.0f)
                lineToRelative(-3.0f, 6.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(3.0f, -6.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(14.5f)
                close()
                moveTo(5.0f, 1.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(22.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(1.0f)
                close()
                moveTo(7.0f, 6.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _chargingStation!!
    }

private var _chargingStation: ImageVector? = null
