/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BuildCircle: ImageVector
    get() {
        if (_buildCircle != null) {
            return _buildCircle!!
        }
        _buildCircle = materialIcon(name = "Sharp.BuildCircle") {
            materialPath(pathFillType = EvenOdd) {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(15.14f, 17.25f)
                lineToRelative(-3.76f, -3.76f)
                curveToRelative(-1.22f, 0.43f, -2.64f, 0.17f, -3.62f, -0.81f)
                curveToRelative(-1.11f, -1.11f, -1.3f, -2.79f, -0.59f, -4.1f)
                lineToRelative(2.35f, 2.35f)
                lineToRelative(1.41f, -1.41f)
                lineTo(8.58f, 7.17f)
                curveToRelative(1.32f, -0.71f, 2.99f, -0.52f, 4.1f, 0.59f)
                curveToRelative(0.98f, 0.98f, 1.24f, 2.4f, 0.81f, 3.62f)
                lineToRelative(3.76f, 3.76f)
                lineTo(15.14f, 17.25f)
                close()
            }
        }
        return _buildCircle!!
    }

private var _buildCircle: ImageVector? = null
