/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BedtimeOff: ImageVector
    get() {
        if (_bedtimeOff != null) {
            return _bedtimeOff!!
        }
        _bedtimeOff = materialIcon(name = "Sharp.BedtimeOff") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(2.27f, 2.27f)
                curveTo(2.61f, 8.08f, 2.0f, 9.97f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(2.04f, 0.0f, 3.93f, -0.62f, 5.51f, -1.66f)
                lineToRelative(2.27f, 2.27f)
                lineTo(21.19f, 21.19f)
                close()
            }
            materialPath {
                moveTo(12.34f, 2.02f)
                curveToRelative(-2.18f, -0.07f, -4.19f, 0.55f, -5.85f, 1.64f)
                lineToRelative(4.59f, 4.59f)
                curveTo(10.81f, 6.2f, 11.18f, 4.03f, 12.34f, 2.02f)
                close()
            }
        }
        return _bedtimeOff!!
    }

private var _bedtimeOff: ImageVector? = null
