/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AirlineSeatLegroomNormal: ImageVector
    get() {
        if (_airlineSeatLegroomNormal != null) {
            return _airlineSeatLegroomNormal!!
        }
        _airlineSeatLegroomNormal = materialIcon(name = "Sharp.AirlineSeatLegroomNormal") {
            materialPath {
                moveTo(5.0f, 15.0f)
                lineTo(5.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-2.0f)
                lineTo(5.0f, 15.0f)
                close()
                moveTo(22.0f, 18.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-7.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-5.0f)
                lineTo(12.0f, 3.0f)
                lineTo(6.0f, 3.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-3.0f)
                close()
            }
        }
        return _airlineSeatLegroomNormal!!
    }

private var _airlineSeatLegroomNormal: ImageVector? = null
