/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TurnSlightRight: ImageVector
    get() {
        if (_turnSlightRight != null) {
            return _turnSlightRight!!
        }
        _turnSlightRight = materialIcon(name = "Rounded.TurnSlightRight") {
            materialPath {
                moveTo(12.34f, 5.0f)
                lineTo(12.34f, 5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.66f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(7.41f)
                lineToRelative(-5.0f, 5.0f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-6.58f)
                curveToRelative(0.0f, -0.53f, 0.21f, -1.04f, 0.59f, -1.41f)
                lineToRelative(5.0f, -5.0f)
                horizontalLineToRelative(-1.24f)
                curveTo(12.79f, 6.0f, 12.34f, 5.55f, 12.34f, 5.0f)
                close()
            }
        }
        return _turnSlightRight!!
    }

private var _turnSlightRight: ImageVector? = null
