/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Tungsten: ImageVector
    get() {
        if (_tungsten != null) {
            return _tungsten!!
        }
        _tungsten = materialIcon(name = "Rounded.Tungsten") {
            materialPath {
                moveTo(12.0f, 19.0f)
                lineTo(12.0f, 19.0f)
                curveToRelative(-0.56f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(12.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(20.0f)
                curveTo(13.0f, 19.45f, 12.55f, 19.0f, 12.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(5.99f, 17.09f)
                lineTo(5.28f, 17.8f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.71f, -0.71f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveTo(7.02f, 16.71f, 6.38f, 16.71f, 5.99f, 17.09f)
                close()
            }
            materialPath {
                moveTo(5.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(4.0f)
                curveTo(4.55f, 13.0f, 5.0f, 12.55f, 5.0f, 12.0f)
                lineTo(5.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 11.0f)
                horizontalLineTo(20.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineTo(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(21.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(12.0f)
                curveTo(22.0f, 11.45f, 21.55f, 11.0f, 21.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(18.01f, 17.09f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.71f, 0.71f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(18.01f, 17.09f)
                close()
            }
            materialPath {
                moveTo(15.0f, 8.02f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-2.0f)
                curveTo(9.9f, 3.0f, 9.0f, 3.9f, 9.0f, 5.0f)
                verticalLineToRelative(3.02f)
                curveToRelative(-1.43f, 1.08f, -2.28f, 2.9f, -1.91f, 4.91f)
                curveToRelative(0.36f, 1.95f, 1.9f, 3.55f, 3.84f, 3.95f)
                curveTo(14.16f, 17.56f, 17.0f, 15.11f, 17.0f, 12.0f)
                curveTo(17.0f, 10.37f, 16.21f, 8.94f, 15.0f, 8.02f)
                close()
                moveTo(13.0f, 7.1f)
                curveTo(12.68f, 7.04f, 12.34f, 7.0f, 12.0f, 7.0f)
                reflectiveCurveToRelative(-0.68f, 0.04f, -1.0f, 0.1f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.1f)
                close()
            }
        }
        return _tungsten!!
    }

private var _tungsten: ImageVector? = null
