/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Timer10Select: ImageVector
    get() {
        if (_timer10Select != null) {
            return _timer10Select!!
        }
        _timer10Select = materialIcon(name = "Rounded.Timer10Select") {
            materialPath {
                moveTo(13.0f, 8.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(13.0f)
                moveTo(13.0f, 5.0f)
                horizontalLineToRelative(-3.0f)
                curveTo(8.34f, 5.0f, 7.0f, 6.34f, 7.0f, 8.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                verticalLineTo(8.0f)
                curveTo(16.0f, 6.34f, 14.66f, 5.0f, 13.0f, 5.0f)
                close()
                moveTo(2.5f, 8.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(9.5f)
                curveTo(3.0f, 18.33f, 3.67f, 19.0f, 4.5f, 19.0f)
                horizontalLineToRelative(0.0f)
                curveTo(5.33f, 19.0f, 6.0f, 18.33f, 6.0f, 17.5f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(2.5f)
                curveTo(1.67f, 5.0f, 1.0f, 5.67f, 1.0f, 6.5f)
                verticalLineToRelative(0.0f)
                curveTo(1.0f, 7.33f, 1.67f, 8.0f, 2.5f, 8.0f)
                close()
                moveTo(18.5f, 11.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.68f, -1.5f, 1.5f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.82f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(18.5f)
                close()
            }
        }
        return _timer10Select!!
    }

private var _timer10Select: ImageVector? = null
