/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TextRotationDown: ImageVector
    get() {
        if (_textRotationDown != null) {
            return _textRotationDown!!
        }
        _textRotationDown = materialIcon(name = "Rounded.TextRotationDown") {
            materialPath {
                moveTo(6.35f, 19.65f)
                lineToRelative(1.79f, -1.79f)
                curveToRelative(0.32f, -0.32f, 0.1f, -0.86f, -0.35f, -0.86f)
                lineTo(7.0f, 17.0f)
                lineTo(7.0f, 5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(-0.79f)
                curveToRelative(-0.45f, 0.0f, -0.67f, 0.54f, -0.35f, 0.85f)
                lineToRelative(1.79f, 1.79f)
                curveToRelative(0.19f, 0.2f, 0.51f, 0.2f, 0.7f, 0.01f)
                close()
                moveTo(12.2f, 8.5f)
                verticalLineToRelative(5.0f)
                lineToRelative(-1.6f, 0.66f)
                curveToRelative(-0.36f, 0.15f, -0.6f, 0.5f, -0.6f, 0.89f)
                curveToRelative(0.0f, 0.69f, 0.71f, 1.15f, 1.34f, 0.88f)
                lineToRelative(8.97f, -3.88f)
                curveToRelative(0.42f, -0.18f, 0.69f, -0.59f, 0.69f, -1.05f)
                curveToRelative(0.0f, -0.46f, -0.27f, -0.87f, -0.69f, -1.05f)
                lineToRelative(-8.97f, -3.88f)
                curveToRelative(-0.63f, -0.27f, -1.34f, 0.2f, -1.34f, 0.89f)
                curveToRelative(0.0f, 0.39f, 0.24f, 0.74f, 0.6f, 0.89f)
                lineToRelative(1.6f, 0.65f)
                close()
                moveTo(19.02f, 11.0f)
                lineTo(14.0f, 12.87f)
                lineTo(14.0f, 9.13f)
                lineTo(19.02f, 11.0f)
                close()
            }
        }
        return _textRotationDown!!
    }

private var _textRotationDown: ImageVector? = null
