/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TabletMac: ImageVector
    get() {
        if (_tabletMac != null) {
            return _tabletMac!!
        }
        _tabletMac = materialIcon(name = "Rounded.TabletMac") {
            materialPath {
                moveTo(18.5f, 0.0f)
                horizontalLineToRelative(-14.0f)
                curveTo(3.12f, 0.0f, 2.0f, 1.12f, 2.0f, 2.5f)
                verticalLineToRelative(19.0f)
                curveTo(2.0f, 22.88f, 3.12f, 24.0f, 4.5f, 24.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                verticalLineToRelative(-19.0f)
                curveTo(21.0f, 1.12f, 19.88f, 0.0f, 18.5f, 0.0f)
                close()
                moveTo(11.5f, 23.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(19.0f, 19.0f)
                lineTo(4.0f, 19.0f)
                lineTo(4.0f, 3.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(16.0f)
                close()
            }
        }
        return _tabletMac!!
    }

private var _tabletMac: ImageVector? = null
