/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Synagogue: ImageVector
    get() {
        if (_synagogue != null) {
            return _synagogue!!
        }
        _synagogue = materialIcon(name = "Rounded.Synagogue") {
            materialPath {
                moveTo(6.0f, 8.94f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(0.0f, -4.89f)
                curveToRelative(0.0f, -1.0f, 0.68f, -1.92f, 1.66f, -2.08f)
                curveTo(12.92f, 13.82f, 14.0f, 14.79f, 14.0f, 16.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(8.94f)
                curveToRelative(0.0f, -0.59f, -0.26f, -1.16f, -0.72f, -1.54f)
                lineToRelative(-4.0f, -3.33f)
                curveToRelative(-0.74f, -0.62f, -1.82f, -0.62f, -2.56f, 0.0f)
                lineToRelative(-4.0f, 3.33f)
                curveTo(6.26f, 7.78f, 6.0f, 8.34f, 6.0f, 8.94f)
                close()
                moveTo(13.5f, 10.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveToRelative(-1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveTo(13.5f, 9.17f, 13.5f, 10.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 5.0f)
                curveTo(1.9f, 5.0f, 1.0f, 5.9f, 1.0f, 7.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(7.0f)
                curveTo(5.0f, 5.9f, 4.1f, 5.0f, 3.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 21.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(10.0f)
                curveTo(1.0f, 20.1f, 1.9f, 21.0f, 3.0f, 21.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(7.0f)
                curveTo(23.0f, 5.9f, 22.1f, 5.0f, 21.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 21.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(21.0f)
                close()
            }
        }
        return _synagogue!!
    }

private var _synagogue: ImageVector? = null
