/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Subscript: ImageVector
    get() {
        if (_subscript != null) {
            return _subscript!!
        }
        _subscript = materialIcon(name = "Rounded.Subscript") {
            materialPath {
                moveTo(10.52f, 10.73f)
                lineTo(7.3f, 5.72f)
                curveTo(6.82f, 4.97f, 7.35f, 4.0f, 8.23f, 4.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.39f, 0.0f, 0.74f, 0.2f, 0.95f, 0.53f)
                lineToRelative(2.76f, 4.46f)
                horizontalLineToRelative(0.12f)
                lineToRelative(2.74f, -4.45f)
                curveTo(15.01f, 4.2f, 15.37f, 4.0f, 15.76f, 4.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.88f, 0.0f, 1.42f, 0.98f, 0.94f, 1.72f)
                lineToRelative(-3.23f, 5.0f)
                lineToRelative(3.55f, 5.55f)
                curveTo(17.5f, 17.02f, 16.96f, 18.0f, 16.08f, 18.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.38f, 0.0f, -0.74f, -0.2f, -0.95f, -0.52f)
                lineToRelative(-3.07f, -4.89f)
                horizontalLineToRelative(-0.12f)
                lineToRelative(-3.07f, 4.89f)
                curveTo(8.67f, 17.8f, 8.31f, 18.0f, 7.92f, 18.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.88f, 0.0f, -1.42f, -0.97f, -0.94f, -1.72f)
                lineTo(10.52f, 10.73f)
                close()
                moveTo(23.0f, 19.5f)
                lineTo(23.0f, 19.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                horizontalLineTo(20.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.5f)
                curveTo(22.78f, 20.0f, 23.0f, 19.78f, 23.0f, 19.5f)
                close()
            }
        }
        return _subscript!!
    }

private var _subscript: ImageVector? = null
