/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Spellcheck: ImageVector
    get() {
        if (_spellcheck != null) {
            return _spellcheck!!
        }
        _spellcheck = materialIcon(name = "Rounded.Spellcheck") {
            materialPath {
                moveTo(13.12f, 16.0f)
                curveToRelative(0.69f, 0.0f, 1.15f, -0.69f, 0.9f, -1.32f)
                lineTo(9.77f, 3.87f)
                curveTo(9.56f, 3.34f, 9.06f, 3.0f, 8.5f, 3.0f)
                reflectiveCurveToRelative(-1.06f, 0.34f, -1.27f, 0.87f)
                lineTo(2.98f, 14.68f)
                curveToRelative(-0.25f, 0.63f, 0.22f, 1.32f, 0.9f, 1.32f)
                curveToRelative(0.4f, 0.0f, 0.76f, -0.25f, 0.91f, -0.63f)
                lineTo(5.67f, 13.0f)
                horizontalLineToRelative(5.64f)
                lineToRelative(0.9f, 2.38f)
                curveToRelative(0.15f, 0.37f, 0.51f, 0.62f, 0.91f, 0.62f)
                close()
                moveTo(6.43f, 11.0f)
                lineTo(8.5f, 5.48f)
                lineTo(10.57f, 11.0f)
                lineTo(6.43f, 11.0f)
                close()
                moveTo(20.89f, 12.29f)
                lineToRelative(-7.39f, 7.39f)
                lineToRelative(-2.97f, -2.97f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(3.68f, 3.68f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(8.08f, -8.09f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(-0.38f, -0.39f, -1.02f, -0.39f, -1.4f, -0.01f)
                close()
            }
        }
        return _spellcheck!!
    }

private var _spellcheck: ImageVector? = null
