/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Schema: ImageVector
    get() {
        if (_schema != null) {
            return _schema!!
        }
        _schema = materialIcon(name = "Rounded.Schema") {
            materialPath {
                moveTo(14.0f, 10.5f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-0.5f)
                curveTo(11.0f, 9.67f, 10.33f, 9.0f, 9.5f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.0f)
                curveTo(10.33f, 7.0f, 11.0f, 6.33f, 11.0f, 5.5f)
                verticalLineToRelative(-3.0f)
                curveTo(11.0f, 1.67f, 10.33f, 1.0f, 9.5f, 1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(4.67f, 1.0f, 4.0f, 1.67f, 4.0f, 2.5f)
                verticalLineToRelative(3.0f)
                curveTo(4.0f, 6.33f, 4.67f, 7.0f, 5.5f, 7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(4.67f, 9.0f, 4.0f, 9.67f, 4.0f, 10.5f)
                verticalLineToRelative(3.0f)
                curveTo(4.0f, 14.33f, 4.67f, 15.0f, 5.5f, 15.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(4.67f, 17.0f, 4.0f, 17.67f, 4.0f, 18.5f)
                verticalLineToRelative(3.0f)
                curveTo(4.0f, 22.33f, 4.67f, 23.0f, 5.5f, 23.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(0.5f)
                curveToRelative(0.0f, 0.83f, 0.67f, 1.5f, 1.5f, 1.5f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveTo(21.0f, 9.67f, 20.33f, 9.0f, 19.5f, 9.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(14.67f, 9.0f, 14.0f, 9.67f, 14.0f, 10.5f)
                close()
            }
        }
        return _schema!!
    }

private var _schema: ImageVector? = null
