/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PhoneInTalk: ImageVector
    get() {
        if (_phoneInTalk != null) {
            return _phoneInTalk!!
        }
        _phoneInTalk = materialIcon(name = "Rounded.PhoneInTalk") {
            materialPath {
                moveTo(12.88f, 5.05f)
                curveToRelative(3.18f, 0.4f, 5.67f, 2.89f, 6.07f, 6.07f)
                curveToRelative(0.06f, 0.51f, 0.49f, 0.88f, 0.99f, 0.88f)
                curveToRelative(0.04f, 0.0f, 0.08f, 0.0f, 0.12f, -0.01f)
                curveToRelative(0.55f, -0.07f, 0.94f, -0.57f, 0.87f, -1.12f)
                curveToRelative(-0.51f, -4.09f, -3.72f, -7.3f, -7.81f, -7.81f)
                curveToRelative(-0.55f, -0.06f, -1.05f, 0.33f, -1.11f, 0.88f)
                curveToRelative(-0.07f, 0.55f, 0.32f, 1.05f, 0.87f, 1.11f)
                close()
                moveTo(13.26f, 7.16f)
                curveToRelative(-0.53f, -0.14f, -1.08f, 0.18f, -1.22f, 0.72f)
                reflectiveCurveToRelative(0.18f, 1.08f, 0.72f, 1.22f)
                curveToRelative(1.05f, 0.27f, 1.87f, 1.09f, 2.15f, 2.15f)
                curveToRelative(0.12f, 0.45f, 0.52f, 0.75f, 0.97f, 0.75f)
                curveToRelative(0.08f, 0.0f, 0.17f, -0.01f, 0.25f, -0.03f)
                curveToRelative(0.53f, -0.14f, 0.85f, -0.69f, 0.72f, -1.22f)
                curveToRelative(-0.47f, -1.77f, -1.84f, -3.14f, -3.59f, -3.59f)
                close()
                moveTo(19.23f, 15.26f)
                lineToRelative(-2.54f, -0.29f)
                curveToRelative(-0.61f, -0.07f, -1.21f, 0.14f, -1.64f, 0.57f)
                lineToRelative(-1.84f, 1.84f)
                curveToRelative(-2.83f, -1.44f, -5.15f, -3.75f, -6.59f, -6.59f)
                lineToRelative(1.85f, -1.85f)
                curveToRelative(0.43f, -0.43f, 0.64f, -1.03f, 0.57f, -1.64f)
                lineToRelative(-0.29f, -2.52f)
                curveToRelative(-0.12f, -1.01f, -0.97f, -1.77f, -1.99f, -1.77f)
                lineTo(5.03f, 3.01f)
                curveToRelative(-1.13f, 0.0f, -2.07f, 0.94f, -2.0f, 2.07f)
                curveToRelative(0.53f, 8.54f, 7.36f, 15.36f, 15.89f, 15.89f)
                curveToRelative(1.13f, 0.07f, 2.07f, -0.87f, 2.07f, -2.0f)
                verticalLineToRelative(-1.73f)
                curveToRelative(0.01f, -1.01f, -0.75f, -1.86f, -1.76f, -1.98f)
                close()
            }
        }
        return _phoneInTalk!!
    }

private var _phoneInTalk: ImageVector? = null
