/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LineAxis: ImageVector
    get() {
        if (_lineAxis != null) {
            return _lineAxis!!
        }
        _lineAxis = materialIcon(name = "Rounded.LineAxis") {
            materialPath {
                moveTo(21.34f, 6.77f)
                lineTo(21.34f, 6.77f)
                curveToRelative(-0.4f, -0.4f, -1.07f, -0.39f, -1.45f, 0.04f)
                lineToRelative(-3.33f, 3.74f)
                lineToRelative(-5.65f, -5.24f)
                curveTo(10.12f, 4.58f, 8.9f, 4.6f, 8.14f, 5.36f)
                lineTo(2.7f, 10.81f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.09f, 0.09f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(5.44f, -5.45f)
                lineToRelative(5.59f, 5.19f)
                lineToRelative(-1.73f, 1.95f)
                lineToRelative(-2.58f, -2.58f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(2.7f, 16.8f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(2.8f, 18.3f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(5.3f, -5.3f)
                lineToRelative(2.5f, 2.5f)
                curveToRelative(0.81f, 0.81f, 2.14f, 0.77f, 2.91f, -0.09f)
                lineToRelative(1.78f, -2.01f)
                lineToRelative(3.19f, 2.96f)
                curveToRelative(0.39f, 0.36f, 1.0f, 0.35f, 1.38f, -0.03f)
                lineToRelative(0.01f, -0.01f)
                curveToRelative(0.4f, -0.4f, 0.39f, -1.05f, -0.03f, -1.43f)
                lineToRelative(-3.22f, -2.99f)
                lineToRelative(3.35f, -3.77f)
                curveTo(21.73f, 7.74f, 21.71f, 7.14f, 21.34f, 6.77f)
                close()
            }
        }
        return _lineAxis!!
    }

private var _lineAxis: ImageVector? = null
