/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Html: ImageVector
    get() {
        if (_html != null) {
            return _html!!
        }
        _html = materialIcon(name = "Rounded.Html") {
            materialPath {
                moveTo(21.0f, 15.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.75f)
                curveTo(20.0f, 9.34f, 20.34f, 9.0f, 20.75f, 9.0f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(3.75f)
                horizontalLineToRelative(1.75f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineTo(21.0f)
                close()
                moveTo(16.0f, 10.49f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(3.76f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.25f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(2.75f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                reflectiveCurveTo(16.0f, 13.66f, 16.0f, 13.25f)
                verticalLineTo(10.49f)
                close()
                moveTo(5.0f, 9.75f)
                curveTo(5.0f, 9.34f, 4.66f, 9.0f, 4.25f, 9.0f)
                reflectiveCurveTo(3.5f, 9.34f, 3.5f, 9.75f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(9.75f)
                curveTo(1.5f, 9.34f, 1.16f, 9.0f, 0.75f, 9.0f)
                reflectiveCurveTo(0.0f, 9.34f, 0.0f, 9.75f)
                verticalLineToRelative(4.5f)
                curveTo(0.0f, 14.66f, 0.34f, 15.0f, 0.75f, 15.0f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(12.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.75f)
                curveTo(3.5f, 14.66f, 3.84f, 15.0f, 4.25f, 15.0f)
                reflectiveCurveTo(5.0f, 14.66f, 5.0f, 14.25f)
                verticalLineTo(9.75f)
                close()
                moveTo(10.25f, 10.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                curveTo(11.0f, 9.34f, 10.66f, 9.0f, 10.25f, 9.0f)
                horizontalLineToRelative(-3.5f)
                curveTo(6.34f, 9.0f, 6.0f, 9.34f, 6.0f, 9.75f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(3.75f)
                curveTo(7.75f, 14.66f, 8.09f, 15.0f, 8.5f, 15.0f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(10.5f)
                horizontalLineTo(10.25f)
                close()
            }
        }
        return _html!!
    }

private var _html: ImageVector? = null
