/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Grade: ImageVector
    get() {
        if (_grade != null) {
            return _grade!!
        }
        _grade = materialIcon(name = "Rounded.Grade") {
            materialPath {
                moveTo(12.0f, 17.27f)
                lineToRelative(5.17f, 3.12f)
                curveToRelative(0.38f, 0.23f, 0.85f, -0.11f, 0.75f, -0.54f)
                lineToRelative(-1.37f, -5.88f)
                lineToRelative(4.56f, -3.95f)
                curveToRelative(0.33f, -0.29f, 0.16f, -0.84f, -0.29f, -0.88f)
                lineToRelative(-6.01f, -0.51f)
                lineToRelative(-2.35f, -5.54f)
                curveToRelative(-0.17f, -0.41f, -0.75f, -0.41f, -0.92f, 0.0f)
                lineTo(9.19f, 8.63f)
                lineToRelative(-6.01f, 0.51f)
                curveToRelative(-0.44f, 0.04f, -0.62f, 0.59f, -0.28f, 0.88f)
                lineToRelative(4.56f, 3.95f)
                lineToRelative(-1.37f, 5.88f)
                curveToRelative(-0.1f, 0.43f, 0.37f, 0.77f, 0.75f, 0.54f)
                lineTo(12.0f, 17.27f)
                close()
            }
        }
        return _grade!!
    }

private var _grade: ImageVector? = null
