/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FlightClass: ImageVector
    get() {
        if (_flightClass != null) {
            return _flightClass!!
        }
        _flightClass = materialIcon(name = "Rounded.FlightClass") {
            materialPath {
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(18.0f, 4.9f, 17.1f, 4.0f, 16.0f, 4.0f)
                close()
                moveTo(6.0f, 4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.5f, 8.0f)
                horizontalLineTo(17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(9.49f)
                curveToRelative(-0.88f, 0.0f, -1.66f, -0.58f, -1.92f, -1.43f)
                lineTo(5.08f, 8.28f)
                curveTo(5.03f, 8.09f, 5.0f, 7.9f, 5.0f, 7.71f)
                verticalLineTo(5.0f)
                curveTo(5.0f, 4.45f, 5.45f, 4.0f, 6.0f, 4.0f)
                close()
                moveTo(18.0f, 20.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(8.0f)
                curveTo(17.55f, 19.0f, 18.0f, 19.45f, 18.0f, 20.0f)
                close()
            }
        }
        return _flightClass!!
    }

private var _flightClass: ImageVector? = null
