/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FilterTiltShift: ImageVector
    get() {
        if (_filterTiltShift != null) {
            return _filterTiltShift!!
        }
        _filterTiltShift = materialIcon(name = "Rounded.FilterTiltShift") {
            materialPath {
                moveTo(11.0f, 3.23f)
                curveToRelative(0.0f, -0.64f, -0.59f, -1.13f, -1.21f, -0.99f)
                curveToRelative(-1.12f, 0.26f, -2.18f, 0.7f, -3.12f, 1.3f)
                curveToRelative(-0.53f, 0.34f, -0.61f, 1.1f, -0.16f, 1.55f)
                curveToRelative(0.32f, 0.32f, 0.83f, 0.4f, 1.21f, 0.16f)
                curveToRelative(0.77f, -0.49f, 1.62f, -0.85f, 2.54f, -1.05f)
                curveToRelative(0.44f, -0.1f, 0.74f, -0.51f, 0.74f, -0.97f)
                close()
                moveTo(17.33f, 3.55f)
                curveToRelative(-0.94f, -0.6f, -2.0f, -1.04f, -3.12f, -1.3f)
                curveToRelative(-0.62f, -0.14f, -1.21f, 0.34f, -1.21f, 0.98f)
                curveToRelative(0.0f, 0.45f, 0.3f, 0.87f, 0.74f, 0.96f)
                curveToRelative(0.91f, 0.2f, 1.77f, 0.57f, 2.53f, 1.05f)
                curveToRelative(0.39f, 0.24f, 0.89f, 0.17f, 1.21f, -0.16f)
                curveToRelative(0.46f, -0.44f, 0.39f, -1.19f, -0.15f, -1.53f)
                close()
                moveTo(20.77f, 11.0f)
                curveToRelative(0.64f, 0.0f, 1.13f, -0.59f, 0.99f, -1.21f)
                curveToRelative(-0.26f, -1.12f, -0.7f, -2.18f, -1.3f, -3.12f)
                curveToRelative(-0.34f, -0.53f, -1.1f, -0.61f, -1.55f, -0.16f)
                curveToRelative(-0.32f, 0.32f, -0.4f, 0.83f, -0.16f, 1.21f)
                curveToRelative(0.49f, 0.77f, 0.85f, 1.62f, 1.05f, 2.53f)
                curveToRelative(0.1f, 0.45f, 0.51f, 0.75f, 0.97f, 0.75f)
                close()
                moveTo(5.1f, 6.51f)
                curveToRelative(-0.46f, -0.45f, -1.21f, -0.38f, -1.55f, 0.16f)
                curveToRelative(-0.6f, 0.94f, -1.04f, 2.0f, -1.3f, 3.12f)
                curveToRelative(-0.14f, 0.62f, 0.34f, 1.21f, 0.98f, 1.21f)
                curveToRelative(0.45f, 0.0f, 0.87f, -0.3f, 0.96f, -0.74f)
                curveToRelative(0.2f, -0.91f, 0.57f, -1.77f, 1.05f, -2.53f)
                curveToRelative(0.26f, -0.39f, 0.18f, -0.9f, -0.14f, -1.22f)
                close()
                moveTo(3.23f, 13.0f)
                curveToRelative(-0.64f, 0.0f, -1.13f, 0.59f, -0.99f, 1.21f)
                curveToRelative(0.26f, 1.12f, 0.7f, 2.17f, 1.3f, 3.12f)
                curveToRelative(0.34f, 0.54f, 1.1f, 0.61f, 1.55f, 0.16f)
                curveToRelative(0.32f, -0.32f, 0.4f, -0.83f, 0.15f, -1.21f)
                curveToRelative(-0.49f, -0.76f, -0.85f, -1.61f, -1.05f, -2.53f)
                curveToRelative(-0.09f, -0.45f, -0.5f, -0.75f, -0.96f, -0.75f)
                close()
                moveTo(15.0f, 12.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                close()
                moveTo(18.9f, 17.49f)
                curveToRelative(0.45f, 0.45f, 1.21f, 0.38f, 1.55f, -0.15f)
                curveToRelative(0.6f, -0.94f, 1.04f, -2.0f, 1.3f, -3.11f)
                curveToRelative(0.14f, -0.62f, -0.35f, -1.21f, -0.98f, -1.21f)
                curveToRelative(-0.45f, 0.0f, -0.87f, 0.3f, -0.96f, 0.74f)
                curveToRelative(-0.2f, 0.91f, -0.57f, 1.76f, -1.05f, 2.53f)
                curveToRelative(-0.26f, 0.37f, -0.18f, 0.88f, 0.14f, 1.2f)
                close()
                moveTo(13.0f, 20.77f)
                curveToRelative(0.0f, 0.64f, 0.59f, 1.13f, 1.21f, 0.99f)
                curveToRelative(1.12f, -0.26f, 2.17f, -0.7f, 3.12f, -1.3f)
                curveToRelative(0.54f, -0.34f, 0.61f, -1.1f, 0.16f, -1.55f)
                curveToRelative(-0.32f, -0.32f, -0.83f, -0.4f, -1.21f, -0.15f)
                curveToRelative(-0.76f, 0.49f, -1.61f, 0.85f, -2.53f, 1.05f)
                curveToRelative(-0.45f, 0.09f, -0.75f, 0.5f, -0.75f, 0.96f)
                close()
                moveTo(6.67f, 20.45f)
                curveToRelative(0.95f, 0.6f, 2.0f, 1.04f, 3.12f, 1.3f)
                curveToRelative(0.62f, 0.14f, 1.21f, -0.35f, 1.21f, -0.98f)
                curveToRelative(0.0f, -0.45f, -0.3f, -0.87f, -0.74f, -0.96f)
                curveToRelative(-0.91f, -0.2f, -1.77f, -0.57f, -2.53f, -1.05f)
                curveToRelative(-0.39f, -0.24f, -0.89f, -0.17f, -1.21f, 0.16f)
                curveToRelative(-0.46f, 0.44f, -0.39f, 1.19f, 0.15f, 1.53f)
                close()
            }
        }
        return _filterTiltShift!!
    }

private var _filterTiltShift: ImageVector? = null
