/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Factory: ImageVector
    get() {
        if (_factory != null) {
            return _factory!!
        }
        _factory = materialIcon(name = "Rounded.Factory") {
            materialPath {
                moveTo(14.0f, 10.0f)
                verticalLineTo(8.48f)
                curveToRelative(0.0f, -0.71f, -0.71f, -1.19f, -1.37f, -0.93f)
                lineTo(9.0f, 9.0f)
                verticalLineTo(8.52f)
                curveTo(9.0f, 7.8f, 8.27f, 7.31f, 7.61f, 7.6f)
                lineTo(3.21f, 9.48f)
                curveTo(2.48f, 9.8f, 2.0f, 10.52f, 2.0f, 11.32f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(10.0f)
                horizontalLineTo(14.0f)
                close()
                moveTo(9.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(13.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(17.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(17.0f)
                close()
            }
            materialPath {
                moveTo(20.12f, 2.0f)
                horizontalLineToRelative(-1.23f)
                curveToRelative(-0.51f, 0.0f, -0.93f, 0.38f, -0.99f, 0.88f)
                lineTo(17.2f, 8.5f)
                horizontalLineToRelative(4.6f)
                lineToRelative(-0.69f, -5.62f)
                curveTo(21.05f, 2.38f, 20.62f, 2.0f, 20.12f, 2.0f)
                close()
            }
        }
        return _factory!!
    }

private var _factory: ImageVector? = null
