/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CurrencyLira: ImageVector
    get() {
        if (_currencyLira != null) {
            return _currencyLira!!
        }
        _currencyLira = materialIcon(name = "Rounded.CurrencyLira") {
            materialPath {
                moveTo(9.0f, 15.84f)
                lineToRelative(-1.47f, 0.92f)
                curveTo(6.86f, 17.18f, 6.0f, 16.7f, 6.0f, 15.91f)
                curveToRelative(0.0f, -0.34f, 0.18f, -0.66f, 0.47f, -0.85f)
                lineTo(9.0f, 13.48f)
                verticalLineToRelative(-2.36f)
                lineToRelative(-1.47f, 0.92f)
                curveTo(6.86f, 12.46f, 6.0f, 11.98f, 6.0f, 11.19f)
                curveToRelative(0.0f, -0.34f, 0.18f, -0.66f, 0.47f, -0.85f)
                lineTo(9.0f, 8.76f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.51f)
                lineToRelative(2.47f, -1.55f)
                curveTo(14.14f, 5.54f, 15.0f, 6.02f, 15.0f, 6.81f)
                curveToRelative(0.0f, 0.34f, -0.18f, 0.66f, -0.47f, 0.85f)
                lineTo(11.0f, 9.87f)
                lineToRelative(0.01f, 2.35f)
                lineToRelative(2.46f, -1.54f)
                curveToRelative(0.67f, -0.42f, 1.53f, 0.06f, 1.53f, 0.85f)
                curveToRelative(0.0f, 0.34f, -0.18f, 0.66f, -0.47f, 0.85f)
                lineTo(11.0f, 14.59f)
                verticalLineTo(19.0f)
                curveToRelative(2.47f, 0.0f, 4.52f, -1.79f, 4.93f, -4.15f)
                curveToRelative(0.08f, -0.49f, 0.49f, -0.85f, 0.98f, -0.85f)
                curveToRelative(0.61f, 0.0f, 1.09f, 0.54f, 1.0f, 1.14f)
                curveTo(17.37f, 18.46f, 14.48f, 21.0f, 11.0f, 21.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(15.84f)
                close()
            }
        }
        return _currencyLira!!
    }

private var _currencyLira: ImageVector? = null
