/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CloseFullscreen: ImageVector
    get() {
        if (_closeFullscreen != null) {
            return _closeFullscreen!!
        }
        _closeFullscreen = materialIcon(name = "Rounded.CloseFullscreen") {
            materialPath {
                moveTo(21.29f, 4.12f)
                lineToRelative(-4.59f, 4.59f)
                lineToRelative(1.59f, 1.59f)
                curveToRelative(0.63f, 0.63f, 0.18f, 1.71f, -0.71f, 1.71f)
                horizontalLineTo(13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(6.41f)
                curveToRelative(0.0f, -0.89f, 1.08f, -1.34f, 1.71f, -0.71f)
                lineToRelative(1.59f, 1.59f)
                lineToRelative(4.59f, -4.59f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                verticalLineToRelative(0.0f)
                curveTo(21.68f, 3.1f, 21.68f, 3.73f, 21.29f, 4.12f)
                close()
                moveTo(4.12f, 21.29f)
                lineToRelative(4.59f, -4.59f)
                lineToRelative(1.59f, 1.59f)
                curveToRelative(0.63f, 0.63f, 1.71f, 0.18f, 1.71f, -0.71f)
                verticalLineTo(13.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(6.41f)
                curveToRelative(-0.89f, 0.0f, -1.34f, 1.08f, -0.71f, 1.71f)
                lineToRelative(1.59f, 1.59f)
                lineToRelative(-4.59f, 4.59f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveTo(3.1f, 21.68f, 3.73f, 21.68f, 4.12f, 21.29f)
                close()
            }
        }
        return _closeFullscreen!!
    }

private var _closeFullscreen: ImageVector? = null
