/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BabyChangingStation: ImageVector
    get() {
        if (_babyChangingStation != null) {
            return _babyChangingStation!!
        }
        _babyChangingStation = materialIcon(name = "Rounded.BabyChangingStation") {
            materialPath {
                moveTo(14.0f, 9.0f)
                lineTo(14.0f, 9.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-1.58f)
                curveToRelative(-0.28f, 0.0f, -0.55f, -0.06f, -0.8f, -0.17f)
                lineToRelative(-2.3f, -1.01f)
                lineTo(7.0f, 12.75f)
                verticalLineTo(21.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-8.67f)
                curveToRelative(0.0f, -0.22f, 0.04f, -0.44f, 0.11f, -0.65f)
                lineToRelative(1.48f, -4.32f)
                curveTo(4.96f, 6.25f, 6.22f, 5.69f, 7.3f, 6.18f)
                lineToRelative(4.15f, 1.83f)
                lineTo(13.0f, 8.0f)
                curveTo(13.55f, 8.0f, 14.0f, 8.45f, 14.0f, 9.0f)
                close()
                moveTo(8.0f, 1.0f)
                curveTo(6.9f, 1.0f, 6.0f, 1.9f, 6.0f, 3.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(9.1f, 1.0f, 8.0f, 1.0f)
                close()
                moveTo(10.0f, 19.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(10.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(9.0f, 18.55f, 9.45f, 19.0f, 10.0f, 19.0f)
                close()
                moveTo(19.5f, 16.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(18.0f, 13.67f, 18.0f, 14.5f)
                curveTo(18.0f, 15.33f, 18.67f, 16.0f, 19.5f, 16.0f)
                close()
                moveTo(13.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _babyChangingStation!!
    }

private var _babyChangingStation: ImageVector? = null
